<?xml version="1.0"?>

<!-- Generic stylesheet for viewing XML -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

	<!-- This template will always be executed, even if this stylesheet is not run on the document root -->
	<xsl:template match="/">
		<html>
		<head>
		<script language="JavaScript">
		function checkString(string) {

			tmp1 = string.replace(/%20/g," ");
			tmp2 = tmp1.replace(/%E4/g,"&#228;");
			tmp3 = tmp2.replace(/%F6/g,"&#246;");
			tmp4 = tmp3.replace(/%FC/g,"&#252;");
			tmp5 = tmp4.replace(/%C4/g,"&#196;");
			tmp6 = tmp5.replace(/%D6/g,"&#214;");
			tmp7 = tmp6.replace(/%DC/g,"&#220;");
			tmp8 = tmp7.replace(/%DF/g,"&#223;");

			return tmp8;
		}

		function WriteHref(LinkPath,LinkName)
		{
			document.write(' / <a target="Dir" href="' + LinkPath + '">'+ LinkName + '</a>');
		}

		tmpwindow = window.location.href;
		windowname = tmpwindow.split("/");
		if((parent.length == 0) || (windowname[windowname.length - 1] == "VersionInfo.xml"))
		{
			if(windowname[windowname.length - 1] != "VersionInfo.xml")
				document.write('<title>Export</title>');
			else
				document.write('<title>Version Info</title>');
		}

		else
		{
			rootDirSplit = checkString(parent.location.href).split("/");
			ExportName   = (rootDirSplit[rootDirSplit.length-1]).substring(0,(rootDirSplit[rootDirSplit.length-1]).lastIndexOf('.'));
			NaviSplit    = checkString(window.location.href).split("/");
			LocalName    = (NaviSplit[NaviSplit.length-1]).substring(0,(NaviSplit[NaviSplit.length-1]).lastIndexOf('.'));

			var bDir = 0;
			var iNaviEndOffset = -1;

			if (window.name == "Dir")
			{
				bDir = 1;
				iNaviEndOffset = -2;
				document.write("Navigation bar: ");
			}
			else
				document.write("File: ");

			if (rootDirSplit.length != (NaviSplit.length-1))
			{
				LinkPath = "file://"

				for (i=3; i != (rootDirSplit.length -1); i++) LinkPath += "/" + rootDirSplit[i];
				LinkPath += "/XML_" + ExportName;
				WriteHref(LinkPath + "/XML_" + ExportName + ".xml",ExportName);

				for (i=rootDirSplit.length; i != (NaviSplit.length + iNaviEndOffset); i++)
				{
					LinkPath += "/" + NaviSplit[i];
					WriteHref(LinkPath + "/" + NaviSplit[i] + ".xml",NaviSplit[i]);
				}
				document.write(" / " + LocalName + "<p />");
			}
			else document.write(" / " + ExportName + "<p />");
		}
		</script>

		</head>
			<xsl:apply-templates select="V04_001"/>
		<body>
			<xsl:apply-templates/>
		</body>
		</html>
	</xsl:template>

	<xsl:script language="JavaScript"><![CDATA[
	  function dirdata(e) {

  		var string = e;

 		if (string.lastIndexOf('\\') == string.indexOf('\\')){

  			return 1;

  		}

		return 0;
	  }
	]]></xsl:script>
	<xsl:template match="*[@xlink:href]">
	<xsl:choose>
	<xsl:when  language="JavaScript" expr="dirdata	(this.attributes.item(0).value)">
		<a target="Data"><xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute><xsl:value-of select="@xlink:title"/></a><br/>
	</xsl:when>
	<xsl:otherwise>
		<a target="Dir"><xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute><xsl:value-of select="@xlink:title"/></a><br/>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:template>

	<xsl:template match="Extension">
	<a target="Data"><xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute><xsl:value-of select="@xlink:title"/></a><br/>
	</xsl:template>

	<xsl:template match="V04_001">
		<frameset cols="40%,60%">
			<frame src=".\Extension 1\Extension 1.xml" name="Dir"/>
			<frame name="Data"/>
		</frameset>
	</xsl:template>

</xsl:stylesheet>
